//------------------------------------------------------------------------------
// Lab. 07: Design a full state observer for the system.
//------------------------------------------------------------------------------


//scilab-5.5.0
//Operating System : OS X 10.9.3

//Clean the environment
clc;
clear all;
clf;

//State space model
A=[1 -1 2; 2 -1 3; -1 -2 4];
B=[1 1 0]';
C=[1 1 0];
D=0;

//Stabilizer design
// Desired poles
Pd=[-7 -5 -10];

// State feedback gain matrix
K=ppol(A,B,Pd)

//Computation of observer gain
obsr_pol=[-20+0.5*%i -20-0.5*%i -60];
L=ppol(A',C',obsr_pol)'

// Augmented system
temp=size(A);
Aa=[A-B*K    B*K; zeros(temp(1),temp(2))     A-L*C ];
temp=size(Aa);
Ba=zeros(temp(1),1);
Ca=eye(6,6);
sys=syslin('c',Aa,Ba,Ca,zeros(6,1))

//Observer error 
figure(0)
t=linspace(0,0.6,1001);
x0=[0 0 0 1 1 1 ]';
temp=size(t);
u=zeros(temp(1),temp(2)); // Exogenous signal(step)
y=csim(u,t,sys,x0) 
plot(t,y(4:6,:))
title('Observer error','fontsize',4)
xlabel('$t$','fontsize',2)
ylabel('$x(t)-\hat x(t)$','fontsize',2)
legend('$x_1$','$x_2$','$x_3$')
